#include <GL/glut.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <time.h>
#define PI 3.1415926535

double dex,dey; //player positions and angles

double fov=0.5;

double pconv, texscale;//pixels per coordinate unit and texture to mapscale conversion

const int scrwdth=1024,scrhght=512, numsprites=6, totalsprites=numsprites+1;// the size of each map section and the length of the map, as well as the number of casted rays, and the number of sprites on the map, totalsprites is the number in an array of pointers to *ALL* the sprites

double rays[6][256];// 0 is distance, 1 is what it hits, and 2 is the angle of the ray, 3 is the x position of the ray, 4 is the y position of the ray, 5 is what type of tile it hit

int rres=256, type=1, noclip=0,deltax,fixmouse=1, animframe=0, mapsize=16, mapscale=mapsize*mapsize, mapsel=0;

int frame1,frame2,fps;

int *map=(int*)calloc(sizeof(int),mapscale);//test map array

double movemod;

double drand(){
	return ((double)rand())/(double)(RAND_MAX);
}

void normalize(double *passed, int len){
	double max=abs(passed[0]);
	for(int i=1;i<len;i++){
		if(max<abs(passed[i])){
			max=abs(passed[i]);
		}
	}
	for(int i=0;i<len;i++){
		passed[i]=passed[i]/max;
	}
	
}

double fuldist(double x1, double y1, double x2, double y2){
	return sqrt((x1-x2)*(x1-x2)+(y1-y2)*(y1-y2));
}

double anglefromto(double xf, double yf, double xt, double yt){
	double plang, dist;
	dist=sqrt((xf-xt)*(xf-xt)+(yf-yt)*(yf-yt));
	if(yt-yf<0){
		plang=acos(-(xt-xf)/dist);
	}else{
		plang=acos((xt-xf)/dist);
		plang+=PI;
	}
	return plang;
}

typedef struct{
	int texture[256];
	double colour1[4]={0.5,0.5,0.5,0.7},colour2[4]={0.3,0.3,0.3,0.7},colour3[4]={0.5,0.5,0.5,0.7},colour4[4]={0.3,0.3,0.3,0.7};
}walltextures;
walltextures checkers, smiley, bricks, flesh;

typedef struct{
	int front[3][256], back[3][256], left[3][256], right[3][256], dead[256];
	double colour1[3]={0,0,0},colour2[3]={0,0,0},colour3[3]={0,0,0},colour4[3]={0,0,0};
}spritetextures;

spritetextures fiendtex, lowenfiendtex, oobmonstertex;

typedef struct Entity{
	double x,y,dist, ang=0,speedmod=1-drand()*0.4+0.2, accelmod=1-drand()*0.4+0.2,xloc,yloc;
	double momentum[2], acceleration[2];
	int type=(rand()*4)/RAND_MAX, id=-1;
	int path[256],onpath=0,health=1;
	spritetextures* texture;
}Sprite;

Sprite player, sprite[numsprites], *allsprites[totalsprites], dummy;

Sprite *closesttopoint(double x, double y, double dist){
	Sprite *focus=&dummy;
	double smallestdist=dist, focusdist;
	for(int i=0;i<totalsprites;i++){
		focusdist=fuldist(x,y,allsprites[i]->x,allsprites[i]->y);
		printf("%d, %lf vs %lf\n",allsprites[i]->id,focusdist, smallestdist);
		if(focusdist<smallestdist){
			focus=allsprites[i];
			smallestdist=focusdist;
		}
	}
	return focus;
}

void attack(Sprite *focus, int dmg){
	focus->health=(focus->health-dmg>0)?dmg:0;
}

void populatecolour(FILE *fp, double *colour, int n){//where n is the max in the array
	int colbuff=0;
	for(int i=0;i<n;i++){
		colbuff=(fgetc(fp)-'0')*100;
		colbuff+=(fgetc(fp)-'0')*10;
		colbuff+=(fgetc(fp)-'0');
		colour[i]=((double)colbuff)/255;
		colbuff=0;
		fgetc(fp);
	}
	colbuff=(fgetc(fp)-'0')*100;
	colbuff+=(fgetc(fp)-'0')*10;
	colbuff+=(fgetc(fp)-'0');
	colour[n]=((double)colbuff)/255;
}

void populatewalls(FILE *fp, walltextures *focuswalls){
	int colbuff,skip=0;
	char buff;
	for(int i=0;i<256+16;i++){
		buff=fgetc(fp);
		if(buff!='\n'){
			focuswalls->texture[i-skip]=buff-48;
		}else{
			skip++;
		}
	}
	buff=fgetc(fp);
	while(buff!='S'){
		buff=fgetc(fp);
	}
	//1st colour
	populatecolour(fp,focuswalls->colour1,3);
	buff=fgetc(fp);
	//2nd colour
	populatecolour(fp,focuswalls->colour2,3);
	buff=fgetc(fp);
	//3rd
	populatecolour(fp,focuswalls->colour3,3);
	buff=fgetc(fp);
	//4th
	populatecolour(fp,focuswalls->colour4,3);
	fclose(fp);
}

void populatesprites(char root[], spritetextures *focustextures){
	char copy[256];
	FILE *fp;
	int skip=0, colbuff=0;
	char buff;
	strcpy(copy,root);
	strcat(copy,".txt");
	fp = fopen(copy, "r");
	for(int i=0;i<256+16;i++){
		buff=fgetc(fp);
		if(buff!='\n'){
			focustextures->front[1][i-skip]=buff-48;
		}else{
			skip++;
		}
	}
	buff=fgetc(fp);
	printf("%s\n", copy);
	while(buff!='S'){
		buff=fgetc(fp);
	}
	//1st colour
	populatecolour(fp,focustextures->colour1,2);
	buff=fgetc(fp);
	//2nd colour
	populatecolour(fp,focustextures->colour2,2);
	buff=fgetc(fp);
	//3rd
	populatecolour(fp,focustextures->colour3,2);
	buff=fgetc(fp);
	populatecolour(fp,focustextures->colour4,2);
	fclose(fp);
	skip=0;
	strcpy(copy,root);
	strcat(copy,"l.txt");
	fp = fopen(copy, "r");
	for(int i=0;i<256+16;i++){
		buff=fgetc(fp);
		if(buff!='\n'){
			focustextures->left[1][i-skip]=buff-48;
		}else{
			skip++;
		}
	}
	fclose(fp);
	skip=0;
	strcpy(copy,root);
	strcat(copy,"l.txt");
	fp = fopen(copy, "r");
	for(int i=0;i<256+16;i++){//reading in the left facing texture mirrored then flipping it to get it facing right
		buff=fgetc(fp);
		if(buff!='\n'){
			focustextures->right[1][(1+(i-skip)/16)*16-(i-skip)%16-1]=buff-48;
		}else{
			skip++;
		}
	}
	fclose(fp);
	int rev;
	for(int i=0;i<128;i++){
		rev=focustextures->right[1][i];
		focustextures->right[1][i]=focustextures->right[1][255-i];
		focustextures->right[1][255-i]=rev;
	}
	skip=0;
	strcpy(copy,root);
	strcat(copy,"b.txt");
	fp = fopen(copy, "r");
	for(int i=0;i<256+16;i++){
		buff=fgetc(fp);
		if(buff!='\n'){
			focustextures->back[1][i-skip]=buff-48;
		}else{
			skip++;
		}
	}
	fclose(fp);
	skip=0;
	strcpy(copy,root);
	strcat(copy,"1.txt");
	fp = fopen(copy, "r");
	for(int i=0;i<256+16;i++){
		buff=fgetc(fp);
		if(buff!='\n'){
			focustextures->front[0][i-skip]=buff-48;
		}else{
			skip++;
		}
	}
	fclose(fp);
	skip=0;
	strcpy(copy,root);
	strcat(copy,"1.txt");
	fp = fopen(copy, "r");
	for(int i=0;i<256+16;i++){//reading in the left facing texture mirrored then flipping it to get it facing right
		buff=fgetc(fp);
		if(buff!='\n'){
			focustextures->front[2][(1+(i-skip)/16)*16-(i-skip)%16-1]=buff-48;
		}else{
			skip++;
		}
	}
	fclose(fp);
	for(int i=0;i<128;i++){
		rev=focustextures->front[2][i];
		focustextures->front[2][i]=focustextures->front[2][255-i];
		focustextures->front[2][255-i]=rev;
	}
	skip=0;
	strcpy(copy,root);
	strcat(copy,"b1.txt");
	fp = fopen(copy, "r");
	for(int i=0;i<256+16;i++){
		buff=fgetc(fp);
		if(buff!='\n'){
			focustextures->back[0][i-skip]=buff-48;
		}else{
			skip++;
		}
	}
	fclose(fp);
	skip=0;
	strcpy(copy,root);
	strcat(copy,"b1.txt");
	fp = fopen(copy, "r");
	for(int i=0;i<256+16;i++){//reading in the left facing texture mirrored then flipping it to get it facing right
		buff=fgetc(fp);
		if(buff!='\n'){
			focustextures->back[2][(1+(i-skip)/16)*16-(i-skip)%16-1]=buff-48;
		}else{
			skip++;
		}
	}
	fclose(fp);
	for(int i=0;i<128;i++){
		rev=focustextures->back[2][i];
		focustextures->back[2][i]=focustextures->back[2][255-i];
		focustextures->back[2][255-i]=rev;
	}
	skip=0;
	strcpy(copy,root);
	strcat(copy,"l1.txt");
	fp = fopen(copy, "r");
	for(int i=0;i<256+16;i++){
		buff=fgetc(fp);
		if(buff!='\n'){
			focustextures->left[0][i-skip]=buff-48;
		}else{
			skip++;
		}
	}
	fclose(fp);
	skip=0;
	strcpy(copy,root);
	strcat(copy,"l2.txt");
	fp = fopen(copy, "r");
	for(int i=0;i<256+16;i++){
		buff=fgetc(fp);
		if(buff!='\n'){
			focustextures->left[2][i-skip]=buff-48;
		}else{
			skip++;
		}
	}
	fclose(fp);
	skip=0;
	strcpy(copy,root);
	strcat(copy,"l1.txt");
	fp = fopen(copy, "r");
	for(int i=0;i<256+16;i++){
		buff=fgetc(fp);
		if(buff!='\n'){
			focustextures->right[0][(1+(i-skip)/16)*16-(i-skip)%16-1]=buff-48;
		}else{
			skip++;
		}
	}
	fclose(fp);
	for(int i=0;i<128;i++){
		rev=focustextures->right[0][i];
		focustextures->right[0][i]=focustextures->right[0][255-i];
		focustextures->right[0][255-i]=rev;
	}
	skip=0;
	strcpy(copy,root);
	strcat(copy,"l2.txt");
	fp = fopen(copy, "r");
	for(int i=0;i<256+16;i++){
		buff=fgetc(fp);
		if(buff!='\n'){
			focustextures->right[2][(1+(i-skip)/16)*16-(i-skip)%16-1]=buff-48;
		}else{
			skip++;
		}
	}
	fclose(fp);
	for(int i=0;i<128;i++){
		rev=focustextures->right[2][i];
		focustextures->right[2][i]=focustextures->right[2][255-i];
		focustextures->right[2][255-i]=rev;
	}
	skip=0;
	strcpy(copy,root);
	strcat(copy,"d.txt");
	fp = fopen(copy, "r");
	for(int i=0;i<256+16;i++){
		buff=fgetc(fp);
		if(buff!='\n'){
			focustextures->dead[i-skip]=buff-48;
		}else{
			skip++;
		}
	}
	fclose(fp);
}

void populate(){
	FILE *fp;
	int skip=0, colbuff;
	char buff;
	char pathname[256];
	getcwd(pathname,256);
	strcat(pathname,"\\maps\\map.txt");
	fp = fopen(pathname, "r");
	for(int i=0;i<mapscale+mapsize;i++){
		buff=fgetc(fp);
		if(buff!='\n'){
			map[i-skip]=buff-48;
		}else{
			skip++;
		}
	}
	fclose(fp);/*
	for(int i=0;i<mapsize;i++){
		for(int j=0;j<mapsize;j++){
			if((j==0)||(i==0)||(j==mapsize-1)||(i==mapsize-1)){
				map[i*mapsize+j]=3;
			}
		}
	}*///<- what is this?
	getcwd(pathname,256);
	printf("checkers\n");
	strcat(pathname,"\\textures\\checker.txt");
	fp = fopen(pathname, "r");
	populatewalls(fp,&checkers);
	getcwd(pathname,256);
	printf("smiley\n");
	strcat(pathname,"\\textures\\smiley.txt");
	fp = fopen(pathname, "r");
	populatewalls(fp,&smiley);
	getcwd(pathname,256);
	strcat(pathname,"\\textures\\bricks.txt");
	fp = fopen(pathname, "r");
	printf("bricks\n");
	populatewalls(fp,&bricks);
	getcwd(pathname,256);
	printf("flesh\n");
	strcat(pathname,"\\textures\\flesh.txt");
	fp = fopen(pathname, "r");
	populatewalls(fp,&flesh);
	skip=0;//start of sprite textures
	getcwd(pathname,256);
	strcat(pathname,"\\textures\\fiendtextures\\fiend");
	populatesprites(pathname, &fiendtex);
	getcwd(pathname,256);
	strcat(pathname,"\\textures\\lowenfiendtextures\\obelisk");
	populatesprites(pathname, &lowenfiendtex);
	getcwd(pathname,256);
	strcat(pathname,"\\textures\\oobmonster\\oob");
	populatesprites(pathname, &oobmonstertex);
}

int xytomap(double inx, double iny){
	return(int)((int)(floor(iny/mapscale)*mapsize+floor(inx/mapscale)));
}

int intdistance(int x1, int y1, int x2, int y2){
	return (int)sqrt((x1-x2)*(x1-x2)+(y1-y2)*(y1-y2));
}

int compare (const void * a, const void * b){
  Sprite *orderA = (Sprite *)a;
  Sprite *orderB = (Sprite *)b;
  return ( orderB->dist - orderA->dist );
}

typedef struct node node;
struct node{
	int todes, tohos, scost, loc, discovered=0,maptile;
	node *parent;
};

void pathfind(Sprite *focus, double pathx, double pathy){
	int giveup, pathmap=xytomap(pathx,pathy), focustile,looking, host=xytomap(focus->x,focus->y), depth=0;//pathmap is the desired map tile, focustile is the tile thats being looked at right now, looking is the location of the pointer
	node *p;
	if(pathmap!=focus->path[0]){
		focustile=xytomap(focus->x,focus->y);
		p=(node*)calloc(sizeof(node),mapscale);
		for(int i=0;i<mapscale;i++){
			p[i].todes=99999;
			p[i].tohos=99999;
			p[i].scost=99999;
			p[i].discovered=0;
			p[i].loc=i;
			p[i].maptile=map[i];
		}
		p[focustile].todes=intdistance(focustile%mapsize,focustile/mapsize,pathmap%mapsize,pathmap/mapsize);
		p[focustile].tohos=0;
		p[focustile].scost=99999;
		giveup=1;
		while(giveup&&((pathmap!=focustile)&&(depth<(mapscale*mapsize)))){
			giveup=0;
			p[focustile].discovered=1;
			p[focustile].scost=99999;
			looking=focustile+mapsize;//up one
			if(!p[looking].discovered&&(!p[looking].maptile)){
			p[looking].todes=intdistance(looking%mapsize,looking/mapsize,pathmap%mapsize,pathmap/mapsize);
			p[looking].tohos=intdistance(looking%mapsize,looking/mapsize,host%mapsize,host/mapsize);
			p[looking].scost=p[looking].todes+p[looking].tohos;
			p[looking].parent=&p[focustile];
			giveup=1;
			}
			looking=focustile-mapsize;//down one
			if(!p[looking].discovered&&(!p[looking].maptile)){
			p[looking].todes=intdistance(looking%mapsize,looking/mapsize,pathmap%mapsize,pathmap/mapsize);
			p[looking].tohos=intdistance(looking%mapsize,looking/mapsize,host%mapsize,host/mapsize);
			p[looking].scost=p[looking].todes+p[looking].tohos;
			p[looking].parent=&p[focustile];
			giveup=1;
			}
			looking=focustile-1;//left one
			if(!p[looking].discovered&&(!p[looking].maptile)){
			p[looking].todes=intdistance(looking%mapsize,looking/mapsize,pathmap%mapsize,pathmap/mapsize);
			p[looking].tohos=intdistance(looking%mapsize,looking/mapsize,host%mapsize,host/mapsize);
			p[looking].scost=p[looking].todes+p[looking].tohos;
			p[looking].parent=&p[focustile];
			giveup=1;
			}
			looking=focustile+1;//right one
			if(!p[looking].discovered&&(!p[looking].maptile)){
			p[looking].todes=intdistance(looking%mapsize,looking/mapsize,pathmap%mapsize,pathmap/mapsize);
			p[looking].tohos=intdistance(looking%mapsize,looking/mapsize,host%mapsize,host/mapsize);
			p[looking].scost=p[looking].todes+p[looking].tohos;
			p[looking].parent=&p[focustile];
			giveup=1;
			}
			for(int z=0;z<mapscale;z++){
				if(!(p[z].discovered)&&(p[focustile].scost>=p[z].scost)){
					if((p[focustile].scost!=p[z].scost)||(p[focustile].todes>p[z].todes)){
						focustile=z;
					}
				}
			}
			depth++;
		}
		int i=0;
		while(focustile!=host){
			focus->path[i]=p[focustile].loc;
			focustile=p[focustile].parent->loc;
			i++;
		}
		focus->onpath=i-1;
		free(p);
	}
}

void pushentity(Sprite *focus, Sprite *pusher){
	double mdex, mdey, mang;
	mang=anglefromto(focus->x,focus->y,pusher->x,pusher->y);
	mdex=-(fps*cos(mang)*(0.3*movemod));
	mdey=-(fps*sin(mang)*(0.3*movemod));
	if(!map[(int)((int)((focus->x)/mapscale)+(int)((focus->y-6*mdey)/mapscale)*mapsize)]){
		focus->y-=mdey;
	}else{
		mdey=0;
	}
	if(!map[(int)((int)((focus->x-6*mdex)/mapscale)+(int)((focus->y)/mapscale)*mapsize)]){
		focus->x-=mdex;
	}else{
		mdex=0;
	}
}

void moveentity(Sprite *focus){
	double mdex, mdey, xdist, ydist;
	if(focus->y-focus->yloc<0&&focus->x-focus->xloc<0){
		focus->ang=atan(((focus->y-focus->yloc)/(focus->x-focus->xloc)));
	}else if(focus->y-focus->yloc<0){
		focus->ang=atan(((focus->y-focus->yloc)/(focus->x-focus->xloc)));
		focus->ang+=PI;
	}else if(focus->x-focus->xloc<0){
		focus->ang=atan(((focus->y-focus->yloc)/(focus->x-focus->xloc)));
	}else{
		focus->ang=atan(((focus->y-focus->yloc)/(focus->x-focus->xloc)));
		focus->ang+=PI;
	}
	//mdex=-(fps*cos(focus->ang+focus->inac)*(0.3*movemod)*focus->speedmod);
	//mdey=-(fps*sin(focus->ang+focus->inac)*(0.3*movemod)*focus->speedmod);
	mdex=focus->momentum[0]*fps*0.03;
	mdey=focus->momentum[1]*fps*0.03;
	for(int i=0;i<numsprites+1;i++){//if its going to need to shove something out of the way
		xdist=abs(focus->x-mdey-allsprites[i]->x);
		ydist=abs(focus->y-mdex-allsprites[i]->y);
		if(((xdist<mapscale*0.5)&&(ydist<mapscale*0.5))&&(focus->id!=allsprites[i]->id)){
			if(sqrt(xdist*xdist+ydist*ydist)<0.5*mapscale){
				pushentity(allsprites[i],focus);
				mdex=0;
				mdey=0;
			}
		}
	}
	if(!map[(int)((int)((focus->x)/mapscale)+(int)((focus->y-6*mdey)/mapscale)*mapsize)]){
		focus->y-=mdey;
	}else{
		focus->momentum[1]=0;
	}
	if(!map[(int)((int)((focus->x-6*mdex)/mapscale)+(int)((focus->y)/mapscale)*mapsize)]){
		focus->x-=mdex;
	}else{
		focus->momentum[1]=0;
	}
}

void drawcreature(){
	double plang,difplang,focusray,minray,lastmin, resscale=1024/rres,stripscale,bfocus,cfocus,plangstrip;
	int infov,min;
	int* focustexture;
	double distances[numsprites];
	qsort(sprite, numsprites,sizeof(Sprite),compare);
	for(int i=0;i<numsprites;i++){
		sprite[i].dist=sqrt((player.x-sprite[i].x)*(player.x-sprite[i].x)+(player.y-sprite[i].y)*(player.y-sprite[i].y));
		if(!type){
		if(sprite[i].dist>mapscale/4){
			if(sprite[i].y-player.y<0){
				plang=acos(-(sprite[i].x-player.x)/(sprite[i].dist));
			}else{
				plang=acos((sprite[i].x-player.x)/(sprite[i].dist));
				plang+=PI;
			}
			difplang=player.ang-plang;
			if(difplang>=PI*2){
				difplang-=2*PI;
			}
			infov=0;
			if(abs(difplang)<(fov*1.6)||abs(difplang+2*PI)<(fov*1.6)||abs(difplang-2*PI)<(fov*1.6)){
				infov=1;
			}
			if(infov){
				lastmin=0;
				for(int a=0;a<16;a++){//drawing each line
				min=0;
				minray=10000;
				for(int r=0;r<rres;r++){
					focusray=rays[2][r];
					if(focusray<0){
						focusray+=2*PI;
					}else if(focusray>=2*PI){
						focusray-=2*PI;
					}
					plangstrip=plang+((a-8)/(sprite[i].dist/(mapscale/64)))*PI;//PROBLEM AREA
					if(plangstrip>=PI*2){
						plangstrip-=2*PI;
					}else if(plangstrip<0){
						plangstrip+=2*PI;
					}
					if (abs(plangstrip-focusray)<abs(plangstrip-minray)){
						min=r;
						minray=focusray;
					}
				}
				if(rays[0][min]>sprite[i].dist){
					if(!lastmin||abs(min-lastmin)>=rres-3){
						lastmin=min-1;
					}
					stripscale=256/((sprite[i].dist*cos(player.ang-rays[2][min]))/mapscale);
					focusray=sprite[i].ang-plang;
					if(focusray>=2*PI){
						focusray-=2*PI;
					}else if(focusray<=0){
						focusray+=2*PI;
					}
					if(sprite[i].health){
						if(focusray<=PI*0.25||focusray>PI*1.75){
							focustexture=sprite[i].texture->front[animframe%3];
						}else if(focusray>PI*0.25&&focusray<=PI*0.75){
							focustexture=sprite[i].texture->left[animframe%3];
						}else if(focusray>PI*0.75&&focusray<=PI*1.25){
							focustexture=sprite[i].texture->back[animframe%3];
						}else{
							focustexture=sprite[i].texture->right[animframe%3];
						}
					}else{
						focustexture=sprite[i].texture->dead;
					}
					for(int b=0;b<16;b++){
						if(focustexture[a*16+b]){
							switch(focustexture[a*16+b]){
								case 1:
								glColor3f(sprite[i].texture->colour1[0],sprite[i].texture->colour1[1],sprite[i].texture->colour1[2]);
								break;
								case 2:
								glColor3f(sprite[i].texture->colour2[0],sprite[i].texture->colour2[1],sprite[i].texture->colour2[2]);
								break;
								case 3:
								glColor3f(sprite[i].texture->colour3[0],sprite[i].texture->colour3[1],sprite[i].texture->colour3[2]);
								break;
								case 4:
								glColor3f(sprite[i].texture->colour4[0],sprite[i].texture->colour4[1],sprite[i].texture->colour4[2]);
								break;
								default:
								glColor3f(0,0,0);
								break;
							}
							bfocus=2*stripscale*((double)b/16);
							cfocus=2*stripscale*((double)(b+1)/16);
							glBegin(GL_QUADS);
							glVertex2i(lastmin*resscale,(256-stripscale)+bfocus+50);
							glVertex2i(min*resscale,(256-stripscale)+bfocus+50);
							glVertex2i(min*resscale,(256-stripscale)+cfocus+50);
							glVertex2i(lastmin*resscale,(256-stripscale)+cfocus+50);
							glEnd();
						}
					}
					lastmin=min;
				}
			}
			}
		}
	}else{
		glColor3f(0,0,1);
		glPointSize(5);
		glBegin(GL_POINTS);
		glVertex2i(sprite[i].x/pconv,sprite[i].y/pconv);
		glEnd();
	}
	}
}

void drawmap(){//draws the map array
	glColor3f(0.8,0.8,0.8);
	int x=0, y=0;
	for(x=0;x<mapsize;x++){
		for(y=0;y<mapsize;y++){
			if (map[x+y*mapsize]){
				glBegin(GL_QUADS);
				glVertex2i(x*(512/mapsize),y*(512/mapsize));
				glVertex2i(x*(512/mapsize),y*(512/mapsize)+(512/mapsize));
				glVertex2i(x*(512/mapsize)+(512/mapsize),y*(512/mapsize)+(512/mapsize));
				glVertex2i(x*(512/mapsize)+(512/mapsize),y*(512/mapsize));
				glEnd();
			}
			
		}
	}
}

void drawcoords(){
	char xcoords[5], ycoords[5];
	int digit=(int)log10(abs(player.x/mapscale)+0.5),digit2,i;
	double holder=player.x/mapscale;
	for(i=digit;i>=0;i--){
		xcoords[i]=((int)holder%10)+'0';
		holder/=10;
	}
	xcoords[digit+1]=' ';
	xcoords[digit+2]='\0';
	holder=player.y/mapscale;
	digit2=(int)log10(abs(holder)+0.5);
	for(i=digit2;i>=0;i--){
		ycoords[i]=((int)holder%10)+'0';
		holder/=10;
	}
	ycoords[digit2+1]='\0';
	digit+=digit2+3;
	strcat(xcoords,ycoords);
	glColor3f(0,0,0);
	glRasterPos2f(15,30);
	for(int i=0;i<digit;i++){
		glutBitmapCharacter(GLUT_BITMAP_8_BY_13,xcoords[i]);
	}
	glBegin(GL_TRIANGLES);
	glVertex2i(15+cos(player.ang+PI)*15,45+sin(player.ang+PI)*15);
	glVertex2i(15+cos(player.ang+PI/2)*3,45+sin(player.ang+PI/2)*3);
	glVertex2i(15+cos(player.ang-PI/2)*3,45+sin(player.ang-PI/2)*3);
	glEnd();
	
}

void drawview(){//512
	int wallhit;
	double resscale,focus,bfocus,cfocus;
	walltextures *focustexture;
	if(!type){//without minimap
		float colour[3];
		resscale=(1024/rres);
		glColor3f(0.4,0.3,0.2);//glColor3f(0.2,0.3,1);
		glBegin(GL_QUADS);
		glVertex2i(0,0);
		glVertex2i(0,256+50);
		glVertex2i(1024,256+50);
		glVertex2i(1024,0);
		glEnd();
		glColor3f(0.3,0.2,0.2);//glColor3f(0.7,0.3,0.2);
		glBegin(GL_QUADS);
		glVertex2i(0,256+50);
		glVertex2i(0,512+50);
		glVertex2i(1024,512+50);
		glVertex2i(1024,256+50);
		glEnd();
		double anglfix;
		for(int i=0;i<rres;i++){//iterates over rays, drawing the rows
			anglfix=cos(player.ang-rays[2][i]);
			wallhit=(int)(rays[1][i]);
			focus=(256/((rays[0][i]*anglfix)/mapscale));
			switch((int)rays[5][i]){
				case 1:focustexture=&checkers;break;
				case 2:focustexture=&smiley;break;
				case 3:focustexture=&bricks;break;
				default:focustexture=&flesh;break;
			}
			for(int j=0;j<16;j++){//draws each row of pixels
				/*switch((int)rays[5][i]){//for textures and colour
					case 1://smiley
				if(wallhit){
					if(texture[j+((int)(rays[3][i]*texscale))%16*16]){
						glColor3f(colour[0],colour[1],colour[2]);
					}else{
						glColor3f(1,0,1);//light colour
					}
				}else{
					if(texture[j+((int)(rays[4][i]*texscale))%16*16]){
						glColor3f(colour[0],colour[1],colour[2]);
					}else{
						glColor3f(0.5,0,0.5);//dark colour
					}
				}
						break;
					case 2://checker board
				if(wallhit){
					if(texture2[j+((int)(rays[3][i]*texscale))%16*16]){
						glColor3f(colour[0],colour[1],colour[2]);
					}else{
						glColor3f(0.2,0.2,0.2);//light colour
					}
				}else{
					if(texture2[j+((int)(rays[4][i]*texscale))%16*16]){
						glColor3f(colour[0],colour[1],colour[2]);
					}else{
						glColor3f(0,0,0);//dark colour
					}
				}
						break;
					case 3://brick wall
				if(wallhit){
					if(texture3[j+((int)(rays[3][i]*texscale))%16*16]){
						glColor3f(colour[0],colour[1],colour[2]);
					}else{
						glColor3f(0.5,0.5,0.5);//light colour
					}
				}else{
					if(texture3[j+((int)(rays[4][i]*texscale))%16*16]){
						glColor3f(colour[0],colour[1],colour[2]);
					}else{
						glColor3f(0.2,0.2,0.2);//dark colour
					}
				}
						break;
					default://flesh
				if(wallhit){
					if(texture4[j+((int)(rays[3][i]*texscale))%16*16]){
						glColor3f(colour[0],colour[1],colour[2]);
					}else{
						glColor3f(0.5,0.5,0.5);//light colour
					}
				}else{
					if(texture4[j+((int)(rays[4][i]*texscale))%16*16]){
						glColor3f(colour[0],colour[1],colour[2]);
					}else{
						glColor3f(0.2,0.2,0.2);//dark colour
					}
				}
						break;
				}*/
				switch(wallhit){
				case 0:switch(focustexture->texture[j+((int)(rays[4][i]*texscale))%16*16]){
					case 0:colour[0]=focustexture->colour1[0];colour[1]=focustexture->colour1[1];colour[2]=focustexture->colour1[2];break;
					case 1:colour[0]=focustexture->colour2[0];colour[1]=focustexture->colour2[1];colour[2]=focustexture->colour2[2];break;
					case 2:colour[0]=focustexture->colour3[0];colour[1]=focustexture->colour3[1];colour[2]=focustexture->colour3[2];break;
					case 3:colour[0]=focustexture->colour4[0];colour[1]=focustexture->colour4[1];colour[2]=focustexture->colour4[2];break;
					default:colour[0]=0;colour[1]=0;colour[2]=0;break;
				}break;
				case 1:switch(focustexture->texture[j+((int)(rays[3][i]*texscale))%16*16]){
					case 0:colour[0]=focustexture->colour1[0]*focustexture->colour1[3];colour[1]=focustexture->colour1[1]*focustexture->colour1[3];colour[2]=focustexture->colour1[2]*focustexture->colour1[3];break;
					case 1:colour[0]=focustexture->colour2[0]*focustexture->colour2[3];colour[1]=focustexture->colour2[1]*focustexture->colour2[3];colour[2]=focustexture->colour2[2]*focustexture->colour2[3];break;
					case 2:colour[0]=focustexture->colour3[0]*focustexture->colour3[3];colour[1]=focustexture->colour3[1]*focustexture->colour3[3];colour[2]=focustexture->colour3[2]*focustexture->colour3[3];break;
					case 3:colour[0]=focustexture->colour4[0]*focustexture->colour4[3];colour[1]=focustexture->colour4[1]*focustexture->colour4[3];colour[2]=focustexture->colour4[2]*focustexture->colour4[3];break;
					default:colour[0]=1;colour[1]=0;colour[2]=0;break;
				}break;
				default:colour[0]=0;colour[1]=0;colour[2]=0;break;
				}
				glColor3f(colour[0],colour[1],colour[2]);
				bfocus=2*focus*((double)j/16);
				cfocus=2*focus*((double)(j+1)/16);
				glBegin(GL_QUADS);
				glVertex2i(i*resscale         ,(256-focus)+bfocus+50);//(int)(512+(512/((rays[0][i])/mapscale)))
				glVertex2i(i*resscale+resscale,(256-focus)+bfocus+50);
				glVertex2i(i*resscale+resscale,(256-focus)+cfocus+50);
				glVertex2i(i*resscale         ,(256-focus)+cfocus+50);
				glEnd();
			}
			/*double floormod=(256/(((rays[0][i]*anglfix))/mapscale));// 0 is distance, 1 is what it hits, and 2 is the angle of the ray, 3 is the x position of the ray, 4 is the y position of the ray, 5 is what type of tile it hit
			for(int j=0;floormod<512;j++){
				if((int)(rays[1][i])){
					if(texture[j%16+((int)(rays[3][i]*texscale))%16*16]){
						glColor3f(0.5,0.3,0.6);
					}else{
						glColor3f(0.2,0.1,0.4);
					}
				}else{
					if(texture[(int)(rays[4][i]*texscale)%16*16+j%16]){
						glColor3f(0.5,0.3,0.6);
					}else{
						glColor3f(0.2,0.1,0.4);
					}
				}
				glBegin(GL_QUADS);
				glVertex2i(i*resscale         ,floormod+306);//(int)(512+(512/((rays[0][i])/mapscale)))
				glVertex2i(i*resscale+resscale,floormod+306);
				floormod=(256/(((rays[0][i]*anglfix-(1+j)*mapsize))/mapscale));
				glVertex2i(i*resscale+resscale,floormod+306);
				glVertex2i(i*resscale         ,floormod+306);
				glEnd();
			}*/
		}
		}
	else{//with minimap
		double focus;
		resscale=(512/rres);
		glColor3f(0.2,0.3,1);
		glBegin(GL_QUADS);
		glVertex2i(512,0+50);
		glVertex2i(512,256+50);
		glVertex2i(1024,256+50);
		glVertex2i(1024,0+50);
		glEnd();
		glColor3f(0.7,0.3,0.2);
		glBegin(GL_QUADS);
		glVertex2i(512,256+50);
		glVertex2i(512,512+50);
		glVertex2i(1024,512+50);
		glVertex2i(1024,256+50);
		glEnd();
		for(int i=0;i<rres;i++){
			focus=(256/((rays[0][i]*cos(player.ang-rays[2][i]))/mapscale));
			if(((int)rays[1][i])%2){
				glColor3f(0.7,0.8,0.7);
			}else{
				glColor3f(0.5,0.7,0.5);
			}
			glBegin(GL_QUADS);
			glVertex2i(512+i*(resscale),(int)(256-focus)+50);//(int)(512+(512/((rays[0][i])/mapscale)))
			glVertex2i(512+i*(resscale)+resscale,(int)(256-focus)+50);
			glVertex2i(512+i*(resscale)+resscale,(int)(256+focus)+50);
			glVertex2i(512+i*(resscale),(int)(256+focus)+50);
			glEnd();
		}
	}
}

void drawplayer(){//draws the player
	glColor3f(0,0,0);
	glPointSize(3);
	glBegin(GL_POINTS);
	glVertex2i(player.x/pconv,player.y/pconv);
	glEnd();
	glBegin(GL_POINTS);
	glVertex2i((player.x-cos(player.ang)*50)/pconv,(player.y-sin(player.ang)*50)/pconv);
	glEnd();
}

int frames=0;

double rayx,rayy,dy, invtan, rangle, rrangle, bluelen, redlen,brayx,brayy;

int j;

void drawrays(){// draws the rays that generate the map!! (:
	int maphitb, maphitr, maphitbb,maphitrr;
	for(int i=0;i<rres;i++){
		j=0;
		rangle=player.ang+((double)(i-rres/2))*(PI*fov)/rres;
		if(rangle<0){
			rangle+=2*PI;
		}else if(rangle>=2*PI){
			rangle-=2*PI;
		}
		rrangle=rangle;
		//if(abs(rangle)<0.001||abs(rangle-2*PI)<0.001){rangle=0;}
		//else if(abs(rangle-PI)<0.01){rangle=PI;}//These three checks round potentially bad angles
		//else if(abs(rrangle-PI/2)<0.01){rrangle=PI/2;}
		//else if(abs(rrangle-(3*PI)/2)<0.01){rrangle=(3*PI)/2;}
		invtan=-1/tan(rangle);/*
		if(abs(invtan)>mapscale*mapsize){
			invtan=mapscale*mapsize;
		}else if (abs(invtan)<0.01){
			invtan=0;
		}*/
		// HORIZONTAL LINES
		if(rangle>0&&rangle<PI){//looking up
			rayy=floor(player.y/mapscale)*mapscale-0.001;
			rayx=(player.y-rayy)*invtan+player.x;
			dy=mapscale;
		}else if(rangle>=PI&&rangle<=2*PI){//looking down
			rayy=ceil(player.y/mapscale)*mapscale+0.001;
			rayx=(player.y-rayy)*invtan+player.x;
			dy=-mapscale;
		}/*else{
			j=mapsize;
			rayy=mapscale*mapscale;
			rayx=mapscale*mapscale;
		}*/
		for(j;j<mapsize;j++){
			if((rayx-player.x)<-mapsize*mapscale||(rayy-player.y)<-mapsize*mapscale||(rayx-player.x)>mapsize*mapscale||(rayy-player.y)>mapsize*mapscale){
				break;
			}
			maphitb=map[(int)(floor(rayy/mapscale)*mapsize+floor(rayx/mapscale))];
			if(maphitb){
				break;
			}else{
				rayy-=dy;
				rayx+=dy*invtan;
			}
		}
		bluelen=(rayx-player.x)*(rayx-player.x)+(rayy-player.y)*(rayy-player.y);
		brayx=rayx;
		brayy=rayy;
		// VERTICAL LINES
		j=0;
		invtan=-tan(rrangle);/*
		if(abs(invtan)>mapscale*mapsize){
			invtan=mapscale*mapsize;
		}else if (abs(invtan)<0.01){
			invtan=0;
		}*/
		if((rrangle<=PI/2)&&(rrangle>=0)||(rrangle>=(PI*3)/2)&&(rrangle<=2*PI)){//looking right
			rayx=floor(player.x/mapscale)*mapscale-0.001;
			rayy=(player.x-rayx)*invtan+player.y;
			dy=-mapscale;
		}else if(rrangle>PI/2&&rrangle<(PI*3)/2){//looking left
			rayx=ceil(player.x/mapscale)*mapscale;
			rayy=(player.x-rayx)*invtan+player.y;
			dy=mapscale;
		}/*else{
			j=mapsize;
			rayy=mapscale*mapscale;
			rayx=mapscale*mapscale;
		}*/
		for(j;j<mapsize;j++){
			//printf("%lf %lf\n", rayx,rayy);
			if((rayx-player.x)<-mapsize*mapscale||(rayy-player.y)<-mapsize*mapscale||(rayx-player.x)>mapsize*mapscale||(rayy-player.y)>mapsize*mapscale){
				break;
			}
			maphitr=map[(int)(floor(rayy/mapscale)*mapsize+floor(rayx/mapscale))];
			if(maphitr){
				break;
			}else{
				rayy-=dy*invtan;
				rayx+=dy;
			}
		}
		redlen=(rayx-player.x)*(rayx-player.x)+(rayy-player.y)*(rayy-player.y);
		if(bluelen<redlen){
			rays[0][i]=sqrt(bluelen);
			rays[1][i]=1;
			rays[5][i]=maphitb;
			rays[2][i]=rangle;
		}else{
			rays[0][i]=sqrt(redlen);
			brayx=rayx;
			brayy=rayy;
			rays[1][i]=0;
			rays[5][i]=maphitr;
			rays[2][i]=rrangle;
		}
		rays[3][i]=brayx;
		rays[4][i]=brayy;
		if(type){
			glColor3f(1,0,0);
			glBegin(GL_LINES);
			glVertex2i(player.x/pconv, player.y/pconv);
			glVertex2i(brayx/pconv, brayy/pconv);
			glEnd();}
	}
}

typedef struct Keys{
	int w=0,a=0,s=0,d=0,q=0,e=0;
}Movement;

Movement movement;

void display(){// display function
	glClear(GL_COLOR_BUFFER_BIT);
	glutSetCursor(GLUT_CURSOR_CROSSHAIR);
	if(type){
	drawmap();
	drawplayer();}
	drawrays();
	drawview();
	drawcoords();
	drawcreature();
	glutSwapBuffers();
}

void timer(int) {
	double xdist,ydist;
    glutPostRedisplay();
	frames++;
	frame2=glutGet(GLUT_ELAPSED_TIME);
	fps=frame2-frame1;
	frame1=frame2;
	/*if(movement.a&&(!type)){//evaluates dex and dey
		if(movement.w){
			dex=fps*cos(player.ang-PI*0.25)*(0.3*movemod);
			dey=fps*sin(player.ang-PI*0.25)*(0.3*movemod);
		}else if(movement.s){
			dex=fps*cos(player.ang+PI*0.25)*(0.3*movemod);
			dey=fps*sin(player.ang+PI*0.25)*(0.3*movemod);
		}else{
			dex=fps*cos(player.ang-PI*0.5)*(0.3*movemod);
			dey=fps*sin(player.ang-PI*0.5)*(0.3*movemod);
			if((noclip||!map[(int)((int)((player.x)/mapscale)+(int)((player.y-6*dey)/mapscale)*mapsize)])){
				player.y-=dey*(1+noclip);
			}
			if((noclip||!map[(int)((int)((player.x-6*dex)/mapscale)+(int)((player.y)/mapscale)*mapsize)])){
				player.x-=dex*(1+noclip);
			}
		}
	}else if(movement.d&&(!type)){
		if(movement.w){
			dex=fps*cos(player.ang+PI*0.25)*(0.3*movemod);
			dey=fps*sin(player.ang+PI*0.25)*(0.3*movemod);
		}else if(movement.s){
			dex=fps*cos(player.ang-PI*0.25)*(0.3*movemod);
			dey=fps*sin(player.ang-PI*0.25)*(0.3*movemod);
		}else{
			dex=fps*cos(player.ang+PI*0.5)*(0.3*movemod);
			dey=fps*sin(player.ang+PI*0.5)*(0.3*movemod);
			if((noclip||!map[(int)((int)((player.x)/mapscale)+(int)((player.y-6*dey)/mapscale)*mapsize)])){
				player.y-=dey*(1+noclip);
			}
			if((noclip||!map[(int)((int)((player.x-6*dex)/mapscale)+(int)((player.y)/mapscale)*mapsize)])){
				player.x-=dex*(1+noclip);
			}
		}
	}else{
		dex=fps*cos(player.ang)*(0.3*movemod);
		dey=fps*sin(player.ang)*(0.3*movemod);
	}*/
	if(movement.a&&(!type)){//evaluates player acceleration
		if(movement.w){
			player.acceleration[0]=-cos(player.ang-PI*0.25);
			player.acceleration[1]=-sin(player.ang-PI*0.25);
		}else if(movement.s){
			player.acceleration[0]=cos(player.ang+PI*0.25);
			player.acceleration[1]=sin(player.ang+PI*0.25);
		}else{
			player.acceleration[0]=cos(player.ang+PI*0.5);
			player.acceleration[1]=sin(player.ang+PI*0.5);
		}
	}else if(movement.d&&(!type)){
		if(movement.w){
			player.acceleration[0]=-cos(player.ang+PI*0.25);
			player.acceleration[1]=-sin(player.ang+PI*0.25);
		}else if(movement.s){
			player.acceleration[0]=cos(player.ang-PI*0.25);
			player.acceleration[1]=sin(player.ang-PI*0.25);
		}else{
			player.acceleration[0]=cos(player.ang-PI*0.5);
			player.acceleration[1]=sin(player.ang-PI*0.5);
		}
	}else if(movement.w){
		player.acceleration[0]=-cos(player.ang);
		player.acceleration[1]=-sin(player.ang);
	}else if(movement.s){
		player.acceleration[0]=cos(player.ang);
		player.acceleration[1]=sin(player.ang);
	}else{
		player.acceleration[0]=0;
		player.acceleration[1]=0;
	}
	player.momentum[0]*=0.93;
	player.momentum[1]*=0.93;
	if(sqrt((player.momentum[0]+player.acceleration[0]*4)*(player.momentum[0]+player.acceleration[0]*4)+(player.momentum[1]+player.acceleration[1]*4)*(player.momentum[1]+player.acceleration[1]*4))<15+noclip*100){
		player.momentum[0]+=player.acceleration[0]*4;
		player.momentum[1]+=player.acceleration[1]*4;
	}
	dex=player.momentum[0]*fps*0.08;
	dey=player.momentum[1]*fps*0.08;
	for(int i=0;i<numsprites+1;i++){
		xdist=abs(player.x-dey-allsprites[i]->x);
		ydist=abs(player.y-dex-allsprites[i]->y);
		if(((xdist<mapscale*0.5)&&(ydist<mapscale*0.5))&&(player.id!=allsprites[i]->id)){
			if(sqrt(xdist*xdist+ydist*ydist)<0.5*mapscale){
				pushentity(allsprites[i],&player);
				dex=0;
				dey=0;
			}
		}
	}
	if(!map[xytomap(player.x+dex,player.y)]||noclip){
		player.x+=dex;
	}else{
		player.momentum[0]=0;
	}
	if(!map[xytomap(player.x,player.y+dey)]||noclip){
		player.y+=dey;
	}else{
		player.momentum[1]=0;
	}
	if(deltax){
	player.ang+=((PI)/(fps*6))*deltax;
	if(player.ang<0){player.ang+=2*PI;}
	if(player.ang>=2*PI){player.ang-=2*PI;}
	}
	if(((movement.a&&type)||movement.e)){player.ang-=(PI*fps)/640;if(player.ang<0){player.ang+=2*PI;}}
	if(((movement.d&&type)||movement.q)){player.ang+=(PI*fps)/640;if(player.ang>=2*PI){player.ang-=2*PI;}}
	if(!(frames%15)){
		switch(animframe){
			case 0:
			animframe=1;
			break;
			case 1:
			animframe=2;
			break;
			case 2:
			animframe=4;
			break;
			case 4:
			animframe=0;
			break;
		}
	}
	if(!((frames)%30)){
	for(int i=0;i<numsprites;i++){
		pathfind(&sprite[i],player.x,player.y);
	}
	}
	for(int i=0;i<numsprites;i++){
		if(sprite[i].health){
			if(sprite[i].onpath&&sprite[i].path[sprite[i].onpath]==xytomap(sprite[i].x,sprite[i].y)){
				sprite[i].onpath--;
			}
			sprite[i].xloc=(sprite[i].path[sprite[i].onpath]%mapsize)*mapscale+mapscale*0.5;
			sprite[i].yloc=(sprite[i].path[sprite[i].onpath]/mapsize)*mapscale+mapscale*0.5;
			sprite[i].acceleration[0]=sprite[i].x-sprite[i].xloc;
			sprite[i].acceleration[1]=sprite[i].y-sprite[i].yloc;
			normalize(sprite[i].acceleration, 2);
			sprite[i].momentum[0]*=0.96;
			sprite[i].momentum[1]*=0.96;
			if(sqrt((sprite[i].momentum[0]+sprite[i].acceleration[0]*4*sprite[i].accelmod)*(sprite[i].momentum[0]+sprite[i].acceleration[0]*4*sprite[i].accelmod)+(sprite[i].momentum[1]+sprite[i].acceleration[1]*4*sprite[i].accelmod)*(sprite[i].momentum[1]+sprite[i].acceleration[1]*4*sprite[i].accelmod))<40*sprite[i].speedmod){
				sprite[i].momentum[0]+=sprite[i].acceleration[0]*4*sprite[i].accelmod;
				sprite[i].momentum[1]+=sprite[i].acceleration[1]*4*sprite[i].accelmod;
			}
			moveentity(&sprite[i]);
		}
	}
    glutTimerFunc(1000/60, timer, 0);
}

void mapinit(){
	double randx=0,randy=0;
	int depth=0;
	mapscale=mapsize*mapsize;
	movemod=mapscale/64;
	pconv=(mapsize*mapsize*mapsize)/512.0;
	randx=0;
	randy=0;
	depth=0;
	while(map[(int)(floor(randy/mapscale)*mapsize+floor(randx/mapscale))]&&depth<100){//calculating random position for player
		randx=(mapsize-2)*(mapscale)*drand()+mapscale;
		randy=(mapsize-2)*(mapscale)*drand()+mapscale;
		depth++;
	}
	if(!(depth<100)){
		map[(int)(floor(randy/mapscale)*mapsize+floor(randx/mapscale))]=0;
	}
	player.x=randx;
	player.y=randy;
	for(int i=0;i<numsprites;i++){//calculating random position for the sprites
		randx=0;
		randy=0;
		depth=0;
		sprite[i].health=1;
		if(sprite[i].type==1){
			sprite[i].texture = &lowenfiendtex;
		}else if(sprite[i].type==2){
			sprite[i].texture = &oobmonstertex;
		}else{
			sprite[i].texture = &fiendtex;
		}
		while(map[(int)(floor(randy/mapscale)*mapsize+floor(randx/mapscale))]&&depth<100){
			randx=(mapsize-2)*(mapscale)*drand()+mapscale;
			randy=(mapsize-2)*(mapscale)*drand()+mapscale;
			depth++;
		}
		if(!(depth<100)){
			map[(int)(floor(randy/mapscale)*mapsize+floor(randx/mapscale))]=0;
		}
		sprite[i].x=randx;
		sprite[i].y=randy;
	}
	texscale=16.0/mapscale;//16.0/mapscale
	player.ang=0;
	allsprites[0]=&player;
	for(int i=1;i<numsprites+1;i++){
		allsprites[i]=&sprite[i-1];
		printf("id %d, ",i);
	}
	for(int i=0;i<numsprites+1;i++){
		allsprites[i]->id=i;
	}
}

void init(){//initializes
	srand(time(NULL));
	populate();
	glClearColor(1,1,1,0);
	gluOrtho2D(0,scrwdth,scrhght,0);
	player.type=-1;
	player.speedmod=1;
	mapinit();
	frame1=0;
}

void mine(double minex, double miney){
	int maphit=map[(int)((int)((minex)/mapscale)+(int)(miney/mapscale)*mapsize)];
	if(maphit&&maphit!=3){
		map[(int)((int)((minex)/mapscale)+(int)(miney/mapscale)*mapsize)]=0;
	}
}

void place(double minex, double miney){
	int maphit=map[(int)((int)((minex)/mapscale)+(int)(miney/mapscale)*mapsize)];
		map[(int)((int)((minex)/mapscale)+(int)(miney/mapscale)*mapsize)]=1;
}

void click(int button, int state, int mousex, int mousey){
	if((button==GLUT_LEFT_BUTTON)&&(state==GLUT_DOWN)){
		mine(player.x-cos(player.ang)*mapscale,player.y-sin(player.ang)*mapscale);
	}
	if((button==GLUT_RIGHT_BUTTON)&&(state==GLUT_DOWN)){
		place(player.x-cos(player.ang)*mapscale,player.y-sin(player.ang)*mapscale);
	}
}

void press(unsigned char key, int x, int y){//keyboard inputs
	double xdist, ydist;
	Sprite *holder;
	if(key=='w'){movement.w=1;}
	if(key=='s'){movement.s=1;}
	if(key=='a'){movement.a=1;}
	if(key=='d'){movement.d=1;}
	if(key=='e'){movement.q=1;}
	if(key=='q'){movement.e=1;}
	if(key=='+'){fov+=0.1;}
	if(key=='-'){fov-=0.1;}
	if(key=='*'&&rres<256){rres=rres<<1;}
	if(key=='/'&&rres>1){rres=rres>>1;}
	if(key=='t'){type=(type+1)%2;}
	if(key=='n'){noclip=!noclip;}
	if(key=='p'){
		char buff;
		char pathname[256];
		int skip=0;
		FILE *fp;
		getcwd(pathname,256);
		strcat(pathname,"\\maps\\map");
		mapsel++;
		skip=strlen(pathname);
		pathname[skip]=mapsel+'0';
		pathname[skip+1]='\0';
		skip=0;
		strcat(pathname,".txt");
		fp = fopen(pathname, "r");
		for(int i=0;i<mapscale+mapsize;i++){
			buff=fgetc(fp);
			if(buff!='\n'){
				map[i-skip]=buff-48;
			}else{
				skip++;
			}
		}
		fclose(fp);
		mapinit();
	}
	if(key==' '){
		holder=closesttopoint(player.x-cos(player.ang)*mapscale*0.5,player.y-sin(player.ang)*mapscale*0.5, mapscale*0.5);
		if(holder->id){
			attack(holder,1);
		}
	}
	if(key=='	'){fixmouse=!fixmouse;}
	if(key==27){
		free(map);
		exit(0);
	}
}

void release(unsigned char key, int x, int y){
	if(key=='w'){movement.w=0;}
	if(key=='s'){movement.s=0;}
	if(key=='a'){movement.a=0;}
	if(key=='d'){movement.d=0;}
	if(key=='e'){movement.q=0;}
	if(key=='q'){movement.e=0;}
}

void mouse(int curserx, int cursery){
	if(!type&&fixmouse){
		deltax=curserx-512;
		glutWarpPointer(512,256);
	}
}

int main(int argc, char** argv){ 
	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGBA);
	glutInitWindowSize(scrwdth,scrhght);
	glutCreateWindow("ebic");
	init();
	glutDisplayFunc(display);
	glutKeyboardFunc(press);
	glutKeyboardUpFunc(release);
	glutMouseFunc(click);
	glutPassiveMotionFunc(mouse);
	timer(1);
	glutMainLoop();
}
